#!/usr/bin/php
<?php
// The menu_display function displays menu options to standard output
//     and invokes an action according to user choice
//     $menu is an associative array of 
//     "menu_option_string" =>"handling_function" pairs

function menu_display(&$menu)
{   $i = 0; reset($menu); 
    foreach($menu as $option=>$fn )
    {   $i++;
        echo "$i.  $option\n";
    }
    if ( $i > 0 )
    {  echo "\n";
       $line=trim(readline("Your choice : "));
    }
    if ( $line > 0 && $line <= $i )
    {  reset($menu); $i=0;
       foreach($menu as $option=>$fn )
       {   if ( $line == ++$i ) {  $fn($option, $menu);  }
       }
    }
    else 
    {  echo "*** $line is an invalid choice\n";
       menu_display($menu); 
    }
}

//////// Usage Example ////////

$a_menu=array("Red"=>"redfn", "Green"=>"greenfn", "Blue"=>"bluefn");

// menu action functions
function redfn(&$op, &$mn)  {  reset($mn);  echo "redfn  called\n";  }
function greenfn(&$op, &$mn)  { reset($mn);   echo "greenfn  called\n";  }
function bluefn(&$op, &$mn)  {  reset($mn);  echo "bluefn  called\n";  }

/// note: A menu action function may call the menu_display function
///    with a submenu

menu_display($a_menu);
?>
