<?php require_once("../htmlTable.php");

// $items=associative array of product id and qty
// $action=URL of form action
function cartTable(&$items,$action)
{ global $db_obj;
  $query="";
  if (count($items)==0) return "<p>Shopping cart is empty.</p>";
  foreach($items as $prod=>$qty)
  { $query .= "UNION SELECT id as Product_ID, description AS Description, 
            price AS Price, $qty AS Quantity,
            $qty*price AS Amt
            FROM product  WHERE id='$prod'";
  }
  $query=substr($query,6);
  if ( ($result=$db_obj->query($query)) )
  {  $ans=htmlCart($result,"Product_ID", "Amt",
                    "Quantity", $action, "db");
     $result->close(); return $ans; 
  }
  else return FALSE;
} 

function orderTable($order)
{ global $db_obj;
  $query = "SELECT concat(firstname, ' ', lastname) from customer
      WHERE id=(SELECT customer from orders WHERE id='$order')";
  $customer=value_from_db($query);
  $ans="<p>Customer: $customer,  Order: $order</p>\n";
  $query = "SELECT product.id as Product_ID, product.description 
     AS Description, product.price AS Price, qty AS Quantity,
     qty*product.price AS Amt FROM order_item, product 
     WHERE order_id='$order' && prod_id=product.id";
  if ( ($result=$db_obj->query($query)) )
  {  $ans.=htmlOrder($result,"Amt","db"); $result->close(); return $ans;  }
  else return FALSE;
}

function changeQty($order, $product, $qty)
{ global $db_obj;
  if ( $qty === 0 ) 
  {  removeItem($order, $product);
     return;
  }
  elseif ( $qty > 0 )
  {  $query="INSERT INTO order_item VALUES
          ('$order', '$product', $qty)
          ON DUPLICATE KEY UPDATE qty=$qty";
     return ( $db_obj->query($query) );
  }
}

function removeItem($order, $product)
{ global $db_obj;
  $query="DELETE FROM order_item WHERE
          order_id='$order' && prod_id='$product'";
  if ( $db_obj->query($query) )
  {   $query="SELECT * FROM order_item WHERE order_id='$order'";
      $result=$db_obj->query($query);
      if ($result && $result->num_rows == 0 )
      {  $result->close();
         return (removeOrder($order));
      }
      if ($result) $result->close(); return true;
  }
  return false;
}
$item_stmt=FALSE;

function addItem_p($order, $product, $qty)  // addItem with prepare
{ global $db_obj, $item_stmt, $p_o, $p_p, $p_q;
  if ( !$item_stmt )
  { $item_stmt = $db_obj->prepare(
       "INSERT INTO order_item VALUES (?, ?, ?)
       ON DUPLICATE KEY UPDATE qty=qty+?");
    if ( $item_stmt )
    {  if (! $item_stmt->bind_param('ssii', 
                    $p_o, $p_p, $p_q, $p_q)
          ) $item_stmt=FALSE;
    }
  }
  if ( $item_stmt )
  { $p_o=$order; $p_p=$product; $p_q=$qty;
    return $item_stmt->execute(); 
  }
  return FALSE;
}

function addItem($order, $product, $qty)
{ global $db_obj;
  $query="INSERT INTO order_item VALUES
          ('$order', '$product', $qty)
          ON DUPLICATE KEY UPDATE qty=qty+$qty";
  return ( $db_obj->query($query) );   // true or false
}

function newOrder($order, $customer)
{ global $db_obj;
  $query="INSERT INTO orders VALUES
          ('$order', '$customer', CURRENT_DATE)";
  return ( $db_obj->query($query) );
}

function enterOrder($order, $customer, &$cart)
{ global $db_obj;
  if ( count($cart)==0 ) return false;  // empty order
  $err=FALSE;
  $db_obj->autocommit(FALSE);
  if ( newOrder($order, $customer) )
  {  foreach($cart as $product=>$qty)
     { if (! addItem_p($order,$product,$qty)) 
       { $err=TRUE;  break;  }
     }
     if ( $err ) $db_obj->rollback();
     else  $db_obj->commit();
  }
  else { $db_obj->rollback(); return FALSE;  } 
  $db_obj->autocommit(TRUE);
  return !$err;
}


//  Deleting an order removes all order related entries
//      on the order_item table due to the on delete cascade clause
function removeOrder($order)
{ global $db_obj;
  $query="DELETE FROM orders WHERE id='$order'";
  return ( $db_obj->query($query) );
}

function value_from_db($q)
{   global $db_obj;
    $r = $db_obj->query($q);
    if (  $r && $r->num_rows == 1 )
    {   $row = $r->fetch_row();
        return($row[0]);
    }
    else return FALSE;
}


///// error msg of failed query availabe in $db_obj->error
//// uncomment for testing
// require_once("mysqli.php");
// $cart=array("prod_99008"=>6, "prod_99007"=>7, "prod_99004"=>8);
// $cart=array("prod_99007"=>4, "prod_99008"=>4, "prod_99004"=>4);
// $cart=array("prod_99008"=>6);
//echo cartTable($cart); 
//if (enterOrder("ord_30994", "cus_12002", $cart))
//       echo orderTable("ord_30994"); 
// else echo "failed";
//echo orderTable("ord_01009"); 
// changeQty("ord_01009", "prod_99008", 2);
// removeItem("ord_01009", "prod_99008");
// removeItem("ord_04049", "prod_99007");
?>
