#!/usr/bin/php
<?php
    require_once("mysqli.php");  // creates $db_obj

    function pad_echo($str, $len, $type)
    {  echo(str_pad($str, $len, " ", $type));  } 

    // course table: course_id,title,dept_name,credits

    $stmt = $db_obj->prepare("SELECT * FROM course WHERE dept_name=?")
            or die("prepare failed");

    // binding vars for parameters
    $stmt->bind_param("s", $the_dept);   // string type paremeter

    // vars for result fetching (if desired)
    $len1=8; $len2=28; $len3=15; $len4=2;

    array_shift($argv);

    foreach ($argv as $the_dept)
    {   if (  $stmt->execute()  )  
        {  
	    $r=$stmt->get_result();

	    pad_echo("id", $len1, STR_PAD_RIGHT);
            pad_echo("title", $len2, STR_PAD_RIGHT);
            pad_echo("dept_name", $len3, STR_PAD_RIGHT);
            pad_echo("credits", $len4, STR_PAD_RIGHT);
            echo "\n\n";
            $stmt->bind_result($course_id,$title,$dept_name,$credits);   
            while ( $stmt->fetch() )  
            {   pad_echo($course_id, $len1, STR_PAD_RIGHT);
                pad_echo($title, $len2, STR_PAD_RIGHT);
                pad_echo($dept_name, $len3, STR_PAD_RIGHT);
                pad_echo($credits, $len4, STR_PAD_RIGHT);
                echo "\n";
            }
            echo "\n\n";
        }
    }
    $stmt->close(); /* close statement */

///// To test: 
///// php prepare.php Biology "Comp. Sci."

// Note:  After $stmt->execute()  of result producing query
//     $result = $stmt->get_result();  gets you the result set
//     but it may not work in older PHP versions
?> 
