#!/usr/bin/php
<?php
// The menu_display function displays menu options to standard output
//     and invokes an action according to user choice
//     $menu is an associative array of 
//     "menu_option_string" =>"handling_function" pairs


function menu_display(&$menu)
{   $i = 0;
    foreach($menu as $option=>$fn )
    {   $i++;
        echo "$i.  $option\n";
    }
    if ( $i > 0 )
    {  echo "\n";
       $line=readline("Your choice : ");
    }
    if ( $line > 0 && $line <= $i )
    {  reset($menu); $i=0;
       foreach($menu as $option=>$fn )
       {   if ( $line == ++$i ) {  $fn($option, $menu);  }
       }
    }
    else 
    {  echo "*** $line is an invalid choice\n";
       menu_display($menu); 
    }
}

//////// Usage Example ////////

$g_menu=array("Alpha"=>"a_fn", "Beta"=>"b_fn", "Gamma"=>"c_fn");

// submenu action functions
function a_fn(&$op, &$mn)  {  reset($mn);  echo "a_fn  called\n";  }
function b_fn(&$op, &$mn)  { reset($mn);   echo "b_fn  called\n";  }
function c_fn(&$op, &$mn)  {  reset($mn);  echo "c_fn  called\n";  }

$a_menu=array("Red"=>"redfn", "Green"=>"greenfn", "Blue"=>"bluefn");
// menu action functions
function redfn(&$op, &$mn)  {  reset($mn);  echo "redfn  called\n";  }

/// note: A menu action function may call the menu_display function
///    with a submenu
function greenfn(&$op, &$mn)  
{ global $g_menu;  
  reset($mn);   
  menu_display($g_menu);  
}

function bluefn(&$op, &$mn)  {  reset($mn);  echo "bluefn  called\n";  }


menu_display($a_menu);
?>
